﻿using System;
using System.Web;
using System.Collections.Generic;
using System.Linq;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.Controls.Custom.EFR;
using VIRP_WEB.BaseCode;
using VIRP_WEB.SoaServices;

namespace VIRP_WEB.Custom.EFR
{
    public partial class LabKitOrder : EfrBasePage
    {
        //private readonly LabKitOrderManager labkitMgr = new LabKitOrderManager();

        protected override void Page_Load(object sender, EventArgs e)
        {
            //ReplacePageTitle();
            ReplacePageTitle("My Tasks > Lab Kits > New");

            if (!IsPostBack)
                lblOrderType.Text = "New";
        }

        protected void BtnSave_Click(object sender, EventArgs e)
        {
            List<WKF_CASE_ACTIVITY> activities = new List<WKF_CASE_ACTIVITY>();
            WKF_CASE_ACTIVITY activity;

            foreach (GridViewRow Row in GridViewLabKits.Rows)
            {
                //Load form elemets data to objects
                bool chkPatIdChecked = ((CheckBox)Row.FindControl("chkPatId")).Checked;
                bool chkUseStockChecked = ((CheckBox)Row.FindControl("chkUseStock")).Checked;
                if (chkPatIdChecked || chkUseStockChecked)
                {
                    //For new case activity - create new
                    activity = new WKF_CASE_ACTIVITY();
                    activity.CREATED = activity.UPDATED = DateTime.Now;
                    activity.CREATEDBY = activity.UPDATEDBY = CurrentUser;

                    activity = LoadFormDataToObjects(activity, Row);

                    //use stock vs. order kit
                    activity.KIT_USE_STOCK_FLAG = chkUseStockChecked;

                    // Set the KitOrderedDate
                    FromToDate tb = ((FromToDate)Row.FindControl("OrderDate"));
                    if (tb != null)
                    {
                        DateTime dt = DateTime.Parse(tb.DateValue);
                        activity.KIT_ORDER_DATE = dt;
                    }

                    activities.Add(activity);
                }
            }

            //Insert/Update data
            if (activities.Count == 0)
            {
                ClientScriptManager cs = Page.ClientScript;
                cs.RegisterStartupScript(this.GetType(), "Warn", "alert('Please select a patient to order a kit.');", true);
            }
            else
            {
                //labkitMgr.InsertActivities(activities);
                
                ServiceInterfaceManager.WKF_CASE_ACTIVITY_SAVEALL(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, activities);
                ReDirectPage();
            }
        }

        protected void BindData(int institutionId, int kitTypeId)
        {
        }

        private WKF_CASE_ACTIVITY LoadFormDataToObjects(WKF_CASE_ACTIVITY Activity, GridViewRow Row)
        {
            string userName = HttpContext.Current.User.Identity.Name;

            Activity.WKF_CASE_ID = Convert.ToInt32(GridViewLabKits.DataKeys[Row.RowIndex].Value);
            Activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.Tracking); //Kit ordered
            Activity.STD_WKFACTIVITYTYPE_ID = Convert.ToInt32(VIRP.EFR.BO.WorkFlowActivityTypes.LabKit);
            Activity.CREATEDBY = Activity.UPDATEDBY = userName;
            Activity.REPRESENTATIVE_NAME = userName;
            Activity.CONTACT_NAME = ((TextBox)Row.FindControl("txtVAMCContact")).Text.Trim();
            Activity.CONTACT_PHONE = ((TextBox)Row.FindControl("txtVAMCContactPh")).Text.Trim();
            Activity.ADDRESS_LINE1 = ((TextBox)Row.FindControl("txtAddressLine1")).Text.Trim();
            Activity.ADDRESS_LINE2 = ((TextBox)Row.FindControl("txtAddressLine2")).Text.Trim();
            Activity.ADDRESS_LINE3 = ((TextBox)Row.FindControl("txtAddressLine3")).Text.Trim();
            Activity.CITY = ((TextBox)Row.FindControl("txtCity")).Text.Trim();
            Activity.STATE = ((TextBox)Row.FindControl("txtState")).Text.Trim();
            Activity.COUNTRY = ((TextBox)Row.FindControl("txtCountry")).Text.Trim();
            Activity.POSTAL_CODE = ((TextBox)Row.FindControl("txtPostalCode")).Text.Trim();
            Activity.ZIP_PLUS_4 = ((TextBox)Row.FindControl("txtZip")).Text.Trim();
            Activity.KIT_ORDER_DATE = Helpers.ConvertStringToNullable<DateTime>(((FromToDate)Row.FindControl("OrderDate")).DateValue);
            Activity.COUNTRY = ((TextBox)Row.FindControl("txtCountry")).Text.Trim();

            return Activity;
        }

        private void ReDirectPage()
        {
            Response.Redirect("LabKitOrders.aspx");
        }
        protected void BtnCancel_Click(object sender, EventArgs e)
        {
            ReDirectPage();
        }

        protected void GridViewLabKits_Sorting(object sender, GridViewSortEventArgs e)
        {
        }

        protected void ObjectDataSourceLabKits_Selected(object sender, ObjectDataSourceStatusEventArgs e)
        {
            if (!e.ReturnValue.GetType().IsValueType)
                if (((List<LabKitOrderPatientsBO>)e.ReturnValue).Count() > 0)
                {
                    List<LabKitOrderPatientsBO> Patients = (List<LabKitOrderPatientsBO>)e.ReturnValue;
                    lblInstName.Text = Patients[0].InstName;
                    lblKitType.Text = Patients[0].KitType;

                    ReplacePageTitle("My Tasks > Lab Kits > New > " + lblInstName.Text);
                }
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
        }

        protected override void Ds_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                //e.InputParameters.Clear();

                //string txtSearch = TextBoxSearchCriteria.Text;
                //string listFacility = DropDownListFacility.SelectedValue;

                if (e.InputParameters["CURRENT_USER"] != null)
                    e.InputParameters["CURRENT_USER"] = HttpContext.Current.User.Identity.Name;
                else
                    e.InputParameters.Add("CURRENT_USER", HttpContext.Current.User.Identity.Name);

                if (e.InputParameters["CURRENT_REGISTRY_ID"] != null)
                    e.InputParameters["CURRENT_REGISTRY_ID"] = UserSession.CurrentRegistryId;
                else
                    e.InputParameters.Add("CURRENT_REGISTRY_ID", UserSession.CurrentRegistryId);

                //e.InputParameters.Add("lastName", txtSearch);
                //e.InputParameters.Add("facilityId", listFacility);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }
    }
}
